<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;

class ClientUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name' => 'required',
            'description' => 'required',
            'author' => 'required',
            'authorfunction' => 'required',
            'img' => ['sometimes', 'required'],
            'alt' => ['sometimes', ''],
        ];
    }

    public function messages()
    {
        return [
            'name.required' => 'Nom du client requis',
            'description.required' => 'Description du client requis',
            'author.required' => 'Nom de l\'auteur requis',
            'authorfunction.required' => 'Fonction de l\'auteur requis',
            'img.required' => 'Image ou logo du client ou de l\'entreprise requis'
        ];
    }

    protected function failedValidation(Validator $validator): void
    {
        throw new HttpResponseException(response()->json([
            'status' => 'failed',
            'response' => $validator->errors()
        ], 422));
    }
}
