<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Support\Str;
use App\Http\Requests\ActualityStoreRequest;
use App\Http\Requests\ActualityUpdateRequest;
use App\Models\Actuality;
use Illuminate\Http\Request;
use Validator;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Storage;

class ActualityController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $actuality = Actuality::orderBy('posteddate', 'DESC')->get();
        $actualityLimit = Actuality::orderBy('posteddate', 'DESC')->take(5)->get();

        return response()->json([
            'data' => $actuality,
            'dataLimit' => $actualityLimit,
            'status' => 'Success',
            'response' => 'Actualités chargées avec succès'
        ]);
    }

    public function store(ActualityStoreRequest $request, Actuality $actuality)
    {
        $data = $request->validated();

        $img = $data['img'];
        $filename = Str::uuid()->toString() . '.' . $img->getClientOriginalExtension();
        $img->move(storage_path('app/public/actualities'), $filename);
        $data['img'] = $filename;

        $data['slug'] = Str::slug($request->title, '-');

        $data['posteddate'] = $actuality->getTransformDateFrenchToEnglish($data['posteddate']);

        Actuality::create($data);

        return response()->json([
            'data' => $data,
            'status' => 'Success',
            'response' => 'Actualité ajoutée avec succès'
        ]);
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Actuality  $actuality
     * @return \Illuminate\Http\Response
     */
    public function show(Actuality $actuality, $slug)
    {
        $actuality = Actuality::where('slug', $slug)->first();

        return response()->json([
            'data' => $actuality,
            'status' => 'Success',
            'response' => 'Actualité chargée avec succès'
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Actuality  $actuality
     * @return \Illuminate\Http\Response
     */
    public function edit(Actuality $actuality)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Actuality  $actuality
     * @return \Illuminate\Http\Response
     */
    public function update(ActualityUpdateRequest $request, Actuality $actuality)
    {
        // $validator = Validator::make($request->all(), [
        //     'title' => 'required',
        //     'content' => 'required',
        // ]);

        // if ($validator->fails()) {
        //     return response()->json([
        //         'status' => 'Error',
        //         'Response' => 'Des champs sont requis'
        //     ]);
        // }

        $data = $request->validated();

        $img = $request->file('img');

        if($img != null || $img != '') {
            $imgToDeleted = $actuality->img;
            File::delete(storage_path('app/public/actualities'.$imgToDeleted));
            $filename = 'Actuality-'.$actuality->id.'.'.$img->getClientOriginalExtension();//'Actuality-'.$actuality->id.'.'.$img->getClientOriginalExtension();
            $img->move(storage_path('app/public/actualities'), $filename);
            $data['img'] = $filename;
        }

        $data['slug'] = Str::slug($request->title, '-');

        $actuality->update($data);

        return response()->json([
            'data' => $data,
            'status' => 'Success',
            'response' => 'Actualité modifiée avec succès'
        ]);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Actuality  $actuality
     * @return \Illuminate\Http\Response
     */
    public function destroy(Actuality $actuality)
    {
        File::delete(storage_path('app/public/actualities' . $actuality->img));

        $actuality->delete();

        return response()->json([
            'status' => 'success',
            'response' => 'Actualité supprimée avec succès'
        ]);
    }
}
