<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Requests\ClientStoreRequest;
use App\Http\Requests\ClientUpdateRequest;
use App\Models\Client;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Storage;

class ClientController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $clients = Client::orderBy('created_at', 'DESC')->get();
        $cinqDernierClients = Client::orderBy('created_at', 'DESC')->take(5)->get();

        return response()->json([
            'clients' => $clients,
            'cinqDernierClients' => $cinqDernierClients,
            'status' => 'Success',
            'response' => 'Clients chargés avec succès'
        ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(ClientStoreRequest $request, Client $client)
    {
        $data = $request->validated();

        $img = $data['img'];
        $filename = Str::uuid()->toString() . '.' . $img->getClientOriginalExtension();
        $img->move(storage_path('app/public/clients'), $filename);
        $data['img'] = $filename;

        Client::create($data);

        return response()->json([
            'data' => $data,
            'status' => 'Success',
            'response' => 'Actualité ajoutée avec succès'
        ]);
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Client  $client
     * @return \Illuminate\Http\Response
     */
    public function show(Client $client)
    {
        $client = Client::where('id', $client->id)->first();

        return response()->json([
            'client' => $client,
            'status' => 'Success',
            'response' => 'Client trouvé avec succès'
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Client  $client
     * @return \Illuminate\Http\Response
     */
    public function edit(Client $client)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Client  $client
     * @return \Illuminate\Http\Response
     */
    public function update(ClientUpdateRequest $request, Client $client)
    {
        $data = $request->validated();

        $img = $request->file('img');
        // dd($img);

        if($img != null || $img != '') {
            $imgToDeleted = $client->img;
            File::delete(storage_path('app/public/clients'.$imgToDeleted));
            $filename = 'Client-'.$client->id.'.'.$img->getClientOriginalExtension();
            $img->move(storage_path('app/public/clients'), $filename);
            $data['img'] = $filename;
        }

        $client->update($data);

        return response()->json([
            'data' => $data,
            'status' => 'Success',
            'response' => 'Client modifiée avec succès'
        ]);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Client  $client
     * @return \Illuminate\Http\Response
     */
    public function destroy(Client $client)
    {
        File::delete(storage_path('app/public/clients' . $client->img));

        $client->delete();

        return response()->json([
            'status' => 'success',
            'response' => 'Client supprimé avec succès'
        ]);
    }
}
