<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Requests\ReferecementStoreRequest;
use App\Http\Requests\ReferecementUpdateRequest;
use App\Models\Referencement;
use Illuminate\Http\Request;

class ReferencementController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $referencement = Referencement::orderBy('created_at', 'DESC')->get();

        return response()->json([
            'referencement' => $referencement,
            'Status' => 'success',
            'Response' => 'Liste des referencements chargées avec succès'
        ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(ReferecementStoreRequest $request)
    {
        $data = $request->validated();

        Referencement::create($data);

        return response()->json([
            'data' => $data,
            'status' => 'success',
            'response' => 'Enregistrement effectué avec succès'
        ]);
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Referencement  $referencement
     * @return \Illuminate\Http\Response
     */
    public function show(Referencement $referencement)
    {
        $referencement = Referencement::where('id', $referencement->id)->first();

        return response()->json([
            'referencement' => $referencement,
            'status' => 'Success',
            'response' => 'Referencement trouvé avec succès'
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Referencement  $referencement
     * @return \Illuminate\Http\Response
     */
    public function edit(Referencement $referencement)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Referencement  $referencement
     * @return \Illuminate\Http\Response
     */
    public function update(ReferecementUpdateRequest $request, Referencement $referencement)
    {
        $data = $request->validated();

        $referencement->update($data);

        return response()->json([
            'data' => $data,
            'status' => 'Success',
            'response' => 'Referencement modifié avec succès'
        ]);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Referencement  $referencement
     * @return \Illuminate\Http\Response
     */
    public function destroy(Referencement $referencement)
    {
        $referencement->delete();

        return response()->json([
            'status' => 'success',
            'response' => 'Client supprimé avec succès'
        ]);
    }
}
