<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;

class ContactStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function rules()
    {
        return [
            'nom' => 'required',
            'prenom' => 'required',
            'contact' => 'required',
            'email' => 'required',
            'etr_name' => 'required',
            'ctr_interet' => 'required',
        ];
    }

    public function messages()
    {
        return [
            'nom.required' => 'Le champ nom est obligatoire',
            'prenom.required' => 'Le champ prenom est obligatoire',
            'contact.required' => 'Le champ contact est obligatoire',
            'email.required' => 'Le champ email est obligatoire',
            'etr_name.required' => 'Le champ nom de l\'entreprise est obligatoire',
            'ctr_interet.required' => 'Le champ centre d\'interêt est obligatoire',
        ];
    }

    protected function failedValidation(Validator $validator): void
    {
        throw new HttpResponseException(response()->json([
            'status' => 'failed',
            'response' => $validator->errors()
        ], 422));
    }
}
