<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Requests\Api\Notification\StoreRequest;
use App\Http\Resources\NotificationCollection;
use App\Http\UseCases\Api\Notification\DeleteUseCase;
use App\Http\UseCases\Api\Notification\GetCollectionUseCase;
use App\Http\UseCases\Api\Notification\StoreUseCase;
use App\Models\Notification;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class NotificationsController extends Controller
{
    public function index(Request $request, GetCollectionUseCase $useCase): NotificationCollection
    {
        return $useCase->handle(
            $request->user('sanctum'),
            $request->query('page'),
            $request->query('limit')
        );
    }

    public function store(StoreRequest $request, StoreUseCase $useCase): JsonResponse
    {
        return $useCase->handle($request->user('sanctum'), $request->validated());
    }

    public function destroy(Notification $notification, DeleteUseCase $useCase): JsonResponse
    {
        return $useCase->handle($notification);
    }
}
