<?php

namespace App\Http\Requests\Api\Certificat;

use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;
use App\Http\Concerns\MakeApiResponse;

class StoreRequest extends FormRequest
{
    use MakeApiResponse;

    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'intitule' => 'required',
            'cle_api' => ['required', 'unique:certificats'],
            'cle_securite' => ['required', 'unique:certificats'],
            'date_expiration' => 'required',
            'volume_signatures_total' => 'required'
        ];
    }

    public function messages(): array
    {
        return [
            'intitule.required' => "L'intitule est requis",
            'cle_api.unique' => "La clé API doit être unique",
            'cle_api.required' => "La clé API est requise",
            'cle_securite.unique' => "La clé de sécurité doit être unique",
            'cle_securite.required' => "La clé de sécurité est requise",
            'date_expiration.required' => "La date d'expiration est requise",
            'volume_signatures_total.required' => "Le volume total est requis"
        ];
    }

    protected function failedValidation(Validator $validator): void
    {
        throw new HttpResponseException(
            $this->error($validator->errors()->toArray(), 422)
        );
    }
}
