<?php

namespace App\Http\Requests\Api\Certificat;

use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;
use App\Http\Concerns\MakeApiResponse;

class UpdateRequest extends FormRequest
{
    use MakeApiResponse;

    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'intitule' => ['sometimes', 'required'],
            'cle_api' => [
                'sometimes',
                'required',
                'unique:certificats,cle_api,' . $this->route('certificat')->id
            ],
            'cle_securite' => [
                'sometimes',
                'required',
                'unique:certificats,cle_securite,' . $this->route('certificat')->id
            ],
            'date_expiration' => ['sometimes', 'required'],
            'volume_signatures_total' => ['sometimes', 'required']
        ];
    }

    public function messages(): array
    {
        return [
            'intitule.required' => "L'intitule est requis",
            'cle_api.unique' => "La clé API doit être unique",
            'cle_api.required' => "La clé API est requise",
            'cle_securite.unique' => "La clé de sécurité doit être unique",
            'cle_securite.required' => "La clé de sécurité est requise",
            'date_expiration.required' => "La date d'expiration est requise",
            'volume_signatures_total.required' => "Le volume total est requis"
        ];
    }

    protected function failedValidation(Validator $validator): void
    {
        throw new HttpResponseException(
            $this->error($validator->errors()->toArray(), 422)
        );
    }
}
