<?php

namespace App\Http\Requests\Api\Contact;

use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;
use App\Http\Concerns\MakeApiResponse;

class UpdateRequest extends FormRequest
{
    use MakeApiResponse;

    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'email' => [
                'sometimes',
                'required',
                'email',
                'unique:contacts,email,' . $this->route('contact')->id
            ],
            'nom' => ['sometimes', 'required'],
            'telephone' => [
                'sometimes',
                'required',
                'digits:10',
                'unique:contacts,telephone,' . $this->route('contact')->id
            ],
        ];
    }

    public function messages(): array
    {
        return [
            'email.required' => "L'adresse email est requise",
            'email.email' => "L'adresse email n'est pas valide",
            'email.unique' => "Cette adresse email a déjà été enregistrée",
            'nom.required' => "Le nom est requis",
            'telephone.required' => "Le numéro de téléphone est requis",
            'telephone.digits' => "Le numéro de téléphone ne doit contenir que 10 chiffres",
            'telephone.unique' => "Ce numéro de téléphone a déjà été enregistré",
        ];
    }

    protected function failedValidation(Validator $validator): void
    {
        throw new HttpResponseException(
            $this->error($validator->errors()->toArray(), 422)
        );
    }
}
