<?php

namespace App\Http\Requests\Api\Entreprise;

use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;
use App\Http\Concerns\MakeApiResponse;

class StoreRequest extends FormRequest
{
    use MakeApiResponse;

    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'certificat_id' => 'required',
            'raison_sociale' => 'required',
            'email' => ['required', 'email', 'unique:entreprises'],
            'telephone' => ['required', 'digits:10', 'unique:entreprises'],
            'otp_sms' => ['sometimes', 'required']
        ];
    }

    public function messages(): array
    {
        return [
            'certificat_id.required' => "Le certificat est requis",
            'email.required' => "L'adresse email est requise",
            'email.email' => "L'adresse email n'est pas valide",
            'email.unique' => "Cette adresse email a déjà été enregistrée",
            'raison_sociale.required' => "La raison sociale est requise",
            'telephone.required' => "Le numéro de téléphone est requis",
            'telephone.digits' => "Le numéro de téléphone ne doit contenir que 10 chiffres",
            'telephone.unique' => "Ce numéro de téléphone a déjà été enregistré",
            'otp_sms.required' => "Ce champ est obligatoire"
        ];
    }

    protected function failedValidation(Validator $validator): void
    {
        throw new HttpResponseException(
            $this->error($validator->errors()->toArray(), 422)
        );
    }
}
