<?php

namespace App\Http\Requests\Api\Signataire;

use App\Rules\isValidFileType;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;
use App\Http\Concerns\MakeApiResponse;

class StoreDocumentRequest extends FormRequest
{
    use MakeApiResponse;

    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'document' => ['required', new isValidFileType($this, ['pdf'])],
        ];
    }

    public function messages(): array
    {
        return [
            'document.required' => "Le document à signer est requis",
        ];
    }

    protected function failedValidation(Validator $validator): void
    {
        throw new HttpResponseException(
            $this->error($validator->errors()->toArray(), 422)
        );
    }
}
