<?php

namespace App\Http\Services;

use Illuminate\Http\UploadedFile;

use Illuminate\Support\Str;
use Illuminate\Support\Facades\File;

final class FileUploadService
{
    public function handle(UploadedFile $uploadedFile, &$filename): bool
    {
        $originalFilename = str_replace(['http', 'https'], ['', ''], $uploadedFile->getClientOriginalName());
        $filename = Str::slug(File::name($originalFilename), '_', 'fr') . '_' . strtotime("now")  . '.' . $uploadedFile->getClientOriginalExtension();

        return $uploadedFile->move(storage_path('app/public'), $filename)->isFile();
    }
}
