<?php

namespace App\Http\UseCases\Api\Authentication;

use App\Http\UseCases\Api\AbstractUseCase;
use App\Models\User;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Hash;

final class LoginUseCase extends AbstractUseCase
{
    public function handle(array $data): JsonResponse
    {
        $user = User::query()
            ->where('email', $data['email'])
            ->first();
            
        if (!$user || !Hash::check($data['password'], $user->password)) {
            return $this->error('Adresse mail ou mot de passe incorrect', 401);
        }

        return $this->success([
            'status' => 'success',
            'token' => $user->createToken('app-dkbsign')->plainTextToken,
            'user' => $user
        ]);
    }
}
