<?php

namespace App\Http\UseCases\Api\Certificat;

use App\Http\UseCases\Api\AbstractUseCase;
use App\Models\Certificat;
use Illuminate\Http\JsonResponse;

final class StoreUseCase extends AbstractUseCase
{
    public function handle(array $data): JsonResponse
    {
        return Certificat::factory()->create($data)
            ? $this->success("Le certificat a été enregistré avec succès")
            : $this->error("Echec de l'enregistrement du certificat", 400);
    }
}
