<?php

namespace App\Http\UseCases\Api\Contact;

use App\Http\UseCases\Api\AbstractUseCase;
use App\Models\Contact;
use Illuminate\Http\JsonResponse;

final class UpdateUseCase extends AbstractUseCase
{
    public function handle(Contact $contact, array $data): JsonResponse
    {
        return $contact->update($data)
            ? $this->success('Le contact a été mis à jour avec succès')
            : $this->error("Echec de la mise à jour du contact", 400);
    }
}