<?php

namespace App\Http\UseCases\Api\Entreprise;

use App\Http\Resources\EntrepriseCollection;
use App\Models\Entreprise;

final class GetCollectionUseCase
{
    public function handle(?int $page = null, ?int $limit = null, ?string $search = null): EntrepriseCollection
    {
        $query = Entreprise::query()
            ->when(!is_null($search), function ($q) use ($search) {
                return $q->where('raison_sociale', 'like', "%$search%")
                    ->orWhere('telephone', 'like', "%$search%")
                    ->orWhere('email', 'like', "%$search%");
            })
            ->orderBy('created_at', 'desc');

        if (!is_null($limit)) {
            return new EntrepriseCollection($query->paginate($limit, ['*'], 'page', $page));
        }

        return new EntrepriseCollection($query->get());
    }
}
