<?php

namespace App\Http\UseCases\Api\Entreprise;

use App\Http\UseCases\Api\AbstractUseCase;
use App\Models\Entreprise;
use Illuminate\Http\JsonResponse;

final class StoreUseCase extends AbstractUseCase
{
    public function handle(array $data): JsonResponse
    {
        return Entreprise::factory()->create($data)
            ? $this->success("L'entreprise a été enregistrée avec succès")
            : $this->error("Echec de l'enregistrement de l'entreprise", 400);
    }
}
