<?php

namespace App\Http\UseCases\Api\User;

use App\Http\UseCases\Api\AbstractUseCase;
use App\Models\User;
use Illuminate\Http\JsonResponse;

final class DeleteUseCase extends AbstractUseCase
{
    public function handle(User $user): JsonResponse
    {
        return $user->delete()
            ? $this->success("L'utilisateur a été supprimé avec succès")
            : $this->error("Echec de la suppression de l'utilisateur", 400);
    }
}