<?php

namespace App\Http\UseCases\Api\User;

use App\Http\UseCases\Api\AbstractUseCase;
use App\Models\User;
use App\Notifications\AccountCreatedNotification;
use Exception;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Str;

final class StoreUseCase extends AbstractUseCase
{
    public function handle(array $data): JsonResponse
    {
        $password = app()->environment('production') ? Str::random() : 'password';

        $user = User::factory()->create(
            array_merge($data, ['password' => bcrypt($password)])
        );

        if (!$user) {
            return $this->error("Echec de l'enregistrement de l'utilisateur", 400);
        }
        
        try {
            $user->notify(
                new AccountCreatedNotification(
                    $password, 'https://anrmp.dkbsign.com/login'
                )
            );
        } catch (Exception $e) {}

        return $this->success("L'utilisateur a été enregistré avec succès");
    }
}
