<?php

namespace Database\Seeders;

use App\Models\Certificat;
use App\Models\Entreprise;
use App\Models\User;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     *
     * @return void
     */
    public function run()
    {
        User::factory()->create([
            'nom' => 'DKBSign',
            'prenoms' => 'Admin',
            'role' => User::ROLE_ADMIN,
            'email' => 'admin@dkbsign.com',
            'password' => bcrypt('Admin@DKBSign_2023')
        ]);

        $certificat = Certificat::factory()->create([
            'intitule' => 'Certificat ANRMP',
            'cle_api' => 'arnmp@dkbsignapi',
            'cle_securite' => 'A2VUcQBvAWsNeQAapiUU2ICaVVgA3MBPgNgCjI=',
            'date_expiration' => '2024-09-06',
            'volume_signatures_total' => 100000,
            'volume_signatures_restant' => 80584
        ]);

        $entreprise = Entreprise::factory()
            ->for($certificat)
            ->create([
                'raison_sociale' => 'ANRMP',
                'telephone' => '2722400040',
                'email' => 'info@anrmp.ci',
                'otp_sms' => 0
            ]);

        $users = [
            [
                "nom" => "OUATTARA",
                "prenoms" => "Oumar",
                "telephone" => "0544051717",
                "email" => "o.ouattara@anrmp.ci",
                "email_verified_at" => "2023-08-21T16:26:53.000000Z",
                "fonction" => "Secrétaire Général",
                "signer" => 1,
                "faire_signer" => 0,
                "signer_faire_signer" => 0,
                "role" => "user",
                'password' => '$2y$10$imrT1Xj6FuS1A8JSYOaSIOIA/VDEJPD2aB7YUT2pjpZpr7w5nzW5.'
              ],
              [
                "nom" => "NOMEL",
                "prenoms" => "François",
                "telephone" => "0505300240",
                "email" => "f.nomel@anrmp.ci",
                "email_verified_at" => "2023-08-21T16:33:31.000000Z",
                "fonction" => "Chef de Division des Affaires Financières et du Patrimoine (DAFP)",
                "signer" => 1,
                "faire_signer" => 0,
                "signer_faire_signer" => 0,
                "role" => "user",
                'password' => '$2y$10$jK.C5yCFqwFJ/mJIeE99yO6QUcpz0pEqzdXY2dan.Ag5ioY2/Wz0C'
              ],
              [
                "nom" => "COULIBALY épouse BOTTY",
                "prenoms" => "Hawa",
                "telephone" => "0566072924",
                "email" => "h.botty@anrmp.ci",
                "email_verified_at" => "2023-08-21T16:36:24.000000Z",
                "fonction" => "Assistante au Pool Quitus",
                "signer" => 0,
                "faire_signer" => 1,
                "signer_faire_signer" => 0,
                "role" => "user",
                'password' => '$2y$10$Sze3fjzvafPJROXnAzFGM.LXEVk2FQeBDZK/nqB5S0W.dsoNrIdse'
              ],
              [
                "nom" => "KOTIA épouse AMOAKON",
                "prenoms" => "Sena Véronique",
                "telephone" => "0546019567",
                "email" => "v.amoakon@anrmp.ci",
                "email_verified_at" => "2023-08-21T16:37:21.000000Z",
                "fonction" => "Assistante au Pool Quitus",
                "signer" => 0,
                "faire_signer" => 1,
                "signer_faire_signer" => 0,
                "role" => "user",
                'password' => '$2y$10$OWe/YPyBQs8tL4vIO12wtOk.iqrg57xzIbsc2mN7nXkcijxxZBsDm'
              ],
              [
                "nom" => "TEHIA épouse KRA",
                "prenoms" => "Honorine",
                "telephone" => "0574209616",
                "email" => "h.kra@anrmp.ci",
                "email_verified_at" => "2023-08-21T16:38:16.000000Z",
                "fonction" => "Assistante au Pool Quitus",
                "signer" => 0,
                "faire_signer" => 1,
                "signer_faire_signer" => 0,
                "role" => "user",
                'password' => '$2y$10$s0OaBOXPXMwlXQKD.1tsa.mDx9D4qwGkzFkvHzjI0LjPHYiYS2.J6'
              ],
              [
                "nom" => "KAMARA",
                "prenoms" => "Ismaël",
                "telephone" => "0546019559",
                "email" => "i.kamara@anrmp.ci",
                "email_verified_at" => "2023-08-21T16:39:33.000000Z",
                "fonction" => "Assistant à la DAFP",
                "signer" => 0,
                "faire_signer" => 1,
                "signer_faire_signer" => 0,
                "role" => "user",
                'password' => '$2y$10$10JSlNV6K4lwD67xdfOk5.cTFNSjuteq7pFWAkWytF4guwIYK21hK'
              ],
              [
                "nom" => "KOFFI",
                "prenoms" => "Léandre",
                "telephone" => "0554158686",
                "email" => "l.koffi@anrmp.ci",
                "email_verified_at" => "2023-08-21T16:40:31.000000Z",
                "fonction" => "Chargé d'études à la DSI",
                "signer" => 0,
                "faire_signer" => 1,
                "signer_faire_signer" => 0,
                "role" => "user",
                'password' => '$2y$10$rhvCDRZXLH2OqCAIJR53lO4aa1TDyyOjVSeFpsPsOk0p9yMRi.tfy'
              ],
              [
                "nom" => "KONAN",
                "prenoms" => "Roger",
                "telephone" => "0554158787",
                "email" => "r.konan@anrmp.ci",
                "email_verified_at" => "2023-08-21T16:41:24.000000Z",
                "fonction" => "Chargé d'études à la DSI",
                "signer" => 0,
                "faire_signer" => 1,
                "signer_faire_signer" => 0,
                "role" => "user",
                'password' => '$2y$10$1wGuiCy.7ZKvE4JhfzJ0qel6xZaI.jLDsp3TlqTiNWQQgh8hfRF6y'
              ],
              [
                "nom" => "AKPAH CISSE",
                "prenoms" => "Anne-Rolande",
                "telephone" => "0554158484",
                "email" => "ar.akpah@anrmp.ci",
                "email_verified_at" => "2023-08-23T12:30:38.000000Z",
                "fonction" => "Chef de la Division des Systèmes d'Information (DSI)",
                "signer" => 0,
                "faire_signer" => 1,
                "signer_faire_signer" => 0,
                "role" => "user",
                'password' => '$2y$10$Que0el6X4idcFvjHXVjTYOyHYWNRSLvyqAtgS3NulkrF4AOpwVzTi'
              ],
              [
                "nom" => "Test",
                "prenoms" => "1",
                "telephone" => "0000000001",
                "email" => "test@1.com",
                "email_verified_at" => "2023-08-23T12:30:38.000000Z",
                "fonction" => "Test",
                "signer" => 1,
                "faire_signer" => 1,
                "signer_faire_signer" => 1,
                "role" => "user",
                'password' => bcrypt('password')
              ],
        ];

        foreach ($users as $user) {
            User::factory()->for($entreprise)->create($user);
        }
    }
}
