<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Support\Str;
use App\Http\Requests\ActualityStoreRequest;
use App\Http\Requests\ActualityUpdateRequest;
use App\Models\Actuality;
use Illuminate\Http\Request;
use Validator;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Storage;

class ActualityController extends Controller
{
    public function index()
    {
        $actuality = Actuality::orderBy('posteddate', 'DESC')->get();
        $actualityLimit = Actuality::orderBy('posteddate', 'DESC')->take(5)->get();

        return response()->json([
            'data' => $actuality,
            'dataLimit' => $actualityLimit,
            'status' => 'Success',
            'response' => 'Actualités chargées avec succès'
        ]);
    }

    public function store(ActualityStoreRequest $request, Actuality $actuality)
    {
        $data = $request->validated();

        $img = $data['img'];
        $filename = $img->getClientOriginalName();
        $img->move(storage_path('app/public/actualities'), $filename);
        $data['img'] = $filename;

        $data['slug'] = Str::slug($request->title, '-');

        $data['posteddate'] = $actuality->getTransformDateFrenchToEnglish($data['posteddate']);

        Actuality::create($data);

        return response()->json([
            'data' => $data,
            'status' => 'Success',
            'response' => 'Actualité ajoutée avec succès'
        ]);
    }

    public function show(Actuality $actuality, $slug)
    {
        $actuality = Actuality::where('slug', $slug)->first();

        return response()->json([
            'data' => $actuality,
            'status' => 'Success',
            'response' => 'Actualité chargée avec succès'
        ]);
    }

    public function update(ActualityUpdateRequest $request, Actuality $actuality)
    {
        $data = $request->validated();

        $img = $request->file('img');

        if($img != null || $img != '') {
            $imgToDeleted = $actuality->img;
            // $fileExist = file_exists(storage_path('app/public/actualities/'. $imgToDeleted));
            $fileExist = File::exists(storage_path('app/public/actualities/'. $imgToDeleted));

            if($fileExist){
                unlink(storage_path('app/public/actualities/'.$imgToDeleted));
                $filename = $img->getClientOriginalName();
                $img->move(storage_path('app/public/actualities'), $filename);
                $data['img'] = $filename;
            } else {
                $filename = $img->getClientOriginalName();
                $img->move(storage_path('app/public/actualities'), $filename);
                $data['img'] = $filename;
            }

        }

        $data['slug'] = Str::slug($request->title, '-');

        $actuality->update($data);

        return response()->json([
            'data' => $data,
            'status' => 'Success',
            'response' => 'Actualité modifiée avec succès'
        ]);
    }

    public function destroy(Actuality $actuality)
    {
        $imgToDeleted = $actuality->img;

        $fileExist = File::exists(storage_path('app/public/actualities/'. $imgToDeleted));

        if($fileExist){
            unlink(storage_path('app/public/actualities/'.$imgToDeleted));
            $actuality->delete();
        } else {
            $actuality->delete();
        }

        return response()->json([
            'status' => 'success',
            'response' => 'Actualité supprimée avec succès'
        ]);
    }
}
