<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Requests\DemandedevisStoreRequest;
use App\Mail\DemandedevisMarckdownMail;
use App\Mail\DemandedevisMarckdownMailAdmin;
use App\Models\Demandedevis;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;

class DemandedevisController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $demandedevis = Demandedevis::orderBy('created_at', 'DESC')->get();
        return response()->json([
            'demandedevis' => $demandedevis,
            'status' => 'success',
            'response' => 'Toutes les demandes de dévies sont chargées avec succès'
        ]);
    }

    public function store(DemandedevisStoreRequest $request)
    {
        $data = $request->validated();

        Demandedevis::create($data);

        Mail::to($data['email'])->send(new DemandedevisMarckdownMail($data));
        Mail::to('kouassi.ako4@gmail.com')
            // ->cc('astride.koffi@dkbsolutions.com')
            // ->bcc('fabrice.ako@dkbsolutions.com')
            ->send(new DemandedevisMarckdownMailAdmin($data));

        return response()->json([
            'data' => $data,
            'status' => 'success',
            'response' => 'Demande de dévis envoyer avec succès'
        ]);
    }

    public function show(Demandedevis $demandedevis)
    {
        $demandedevis = Demandedevis::where('id', $demandedevis->id)->first();

        return response()->json([
            'referencement' => $demandedevis,
            'status' => 'Success',
            'response' => 'Demandeurs de dévis trouvé avec succès'
        ]);
    }

    public function destroy(Demandedevis $demandedevis)
    {
        $demandedevis->delete();

        return response()->json([
            'status' => 'success',
            'response' => 'Utilisateur demandeur de dévis supprimé avec succès'
        ]);
    }
}
