<?php

namespace App\Http\Requests;

use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;

class ActualityUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
    */
    public function rules()
    {
        return [
            'title' => 'required',
            'subtitle' => 'required',
            'posteddate' => 'required',
            'content' => 'required',
            'img' => ['sometimes', 'required'],
            'alt' => ['sometimes', ''],
        ];
    }

    public function messages()
    {
        return [
            'title.required' => 'Titre de l\'actualité requis',
            'subtitle.required' => 'Sous Titre de l\'actualité requis',
            'posteddate.required' => 'Date de publication de l\'actualité requis',
            'content.required' => 'Contenu de l\'actualité requis',
            'img.required' => 'Image de l\'actualité requis'
        ];
    }

    protected function failedValidation(Validator $validator): void
    {
        throw new HttpResponseException(response()->json([
            'status' => 'failed',
            'response' => $validator->errors()
        ], 422));
    }
}
