<?php

namespace App\Http\Controllers\Api;

use App\Http\Concerns\MakeApiResponse;
use App\Http\Controllers\Controller;
use App\Http\Requests\Api\Contact\StoreRequest;
use App\Http\Requests\Api\Contact\UpdateRequest;
use App\Http\Requests\Api\Contact\StoreDocumentRequest;
use App\Http\Resources\ContactCollection;
use App\Http\UseCases\Api\Contact\DeleteUseCase;
use App\Http\UseCases\Api\Contact\GetCollectionUseCase;
use App\Http\UseCases\Api\Contact\ImportUseCase;
use App\Http\UseCases\Api\Contact\StoreUseCase;
use App\Http\UseCases\Api\Contact\UpdateUseCase;
use App\Models\Contact;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class ContactController extends Controller
{
    use MakeApiResponse;

    public function index(Request $request, GetCollectionUseCase $useCase): ContactCollection
    {
        return $useCase->handle(
            $request->user('sanctum'),
            $request->query('page'),
            $request->query('limit'),
            $request->query('search')
        );
    }

    public function show(Contact $contact): JsonResponse
    {
        return $this->success($contact);
    }

    public function store(StoreRequest $request, StoreUseCase $useCase): JsonResponse
    {
        return $useCase->handle($request->user('sanctum'), $request->validated());
    }

    public function update(UpdateRequest $request, Contact $contact, UpdateUseCase $useCase): JsonResponse
    {
        $this->authorize('update', $contact);
        return $useCase->handle($contact, $request->validated());
    }

    public function destroy(Contact $contact, DeleteUseCase $useCase): JsonResponse
    {
        $this->authorize('delete', $contact);
        return $useCase->handle($contact);
    }

    public function import(StoreDocumentRequest $request, ImportUseCase $useCase): JsonResponse
    {
        return $useCase->handle(
            $request->user('sanctum'), 
            $request->file('document')
        );
    }
}
