<?php

namespace App\Http\Controllers\Api;

use App\Http\Concerns\MakeApiResponse;
use App\Http\Controllers\Controller;
use App\Http\Requests\Api\User\StoreRequest;
use App\Http\Requests\Api\User\UpdateRequest;
use App\Http\Resources\UserCollection;
use App\Http\UseCases\Api\User\DeleteUseCase;
use App\Http\UseCases\Api\User\GetCollectionUseCase;
use App\Http\UseCases\Api\User\StoreUseCase;
use App\Http\UseCases\Api\User\UpdateUseCase;
use App\Models\User;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class UserController extends Controller
{
    use MakeApiResponse;

    public function index(Request $request, GetCollectionUseCase $useCase): UserCollection
    {
        return $useCase->handle(
            $request->query('page'),
            $request->query('limit'),
            $request->query('search')
        );
    }

    public function show(User $user): JsonResponse
    {
        return $this->success($user);
    }

    public function store(StoreRequest $request, StoreUseCase $useCase): JsonResponse
    {
        return $useCase->handle($request->validated());
    }

    public function update(UpdateRequest $request, User $user, UpdateUseCase $useCase): JsonResponse
    {
        return $useCase->handle($user, $request->validated());
    }

    public function destroy(User $user, DeleteUseCase $useCase): JsonResponse
    {
        return $useCase->handle($user);
    }
}
