<?php

namespace App\Http\Requests\Api\Signataire;

use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;

class SearchRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'query' => 'required',
        ];
    }

    public function messages(): array
    {
        return [
            'query.required' => "Les mots clés sont requis",
        ];
    }

    protected function failedValidation(Validator $validator): void
    {
        throw new HttpResponseException(
            response()
                ->json([
                    'status' => 'error',
                    'response' => $validator->errors()
                ], 422)
        );
    }
}
