<?php

namespace App\Http\Requests\Api\Signataire;

use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;
use App\Http\Concerns\MakeApiResponse;

class StoreRequest extends FormRequest
{
    use MakeApiResponse;

    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'data' => 'required',
            'signataires' => ['sometimes', 'required'],
            'document' => 'required',
            'action' => 'required'
        ];
    }

    public function messages(): array
    {
        return [
            'data.required' => "Les informations de signature sont requises",
            'document.required' => "Le document à signer est requis",
            'signataires.required' => "Les signataires sont requis",
            'action.required' => "L'action est requise"
        ];
    }

    protected function failedValidation(Validator $validator): void
    {
        throw new HttpResponseException(
            $this->error($validator->errors()->toArray(), 422)
        );
    }
}
