<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\ResourceCollection;

class SignataireCollection extends ResourceCollection
{
    /**
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'data' => $this->collection->map(function ($datum) {
                return [
                    'id' => $datum->id, 
                    'document' => $datum->document, 
                    'statut' => $datum->statut,
                    'motif' => $datum->motif,
                    'nom' => $datum->nom,
                    'telephone' => $datum->telephone,
                    'email' => $datum->email,
                    'created_at' => $datum->created_at,
                    'updated_at' => $datum->updated_at,
                    'consulte' => $datum->consulte
                ];
            })
        ];
    }
}
