<?php

namespace App\Http\Services;

use Exception;

final class PDFService 
{
    public function handle(string $filename, &$errorMessage): bool
    {
        try {
            $pdf = new \setasign\Fpdi\Tcpdf\Fpdi();
            $pageCount = $pdf->setSourceFile(storage_path('app/public') . '/' . $filename);

            for ($page = 1; $page <= $pageCount; $page++) {
                $template = $pdf->importPage($page);
                $size = $pdf->getTemplateSize($template);

                $pdf->setPrintHeader(false);
                $pdf->setPrintFooter(false);

                if ($size['height'] > $size['width']) {
                    $pdf->addPage('P');
                    $pdf->useTemplate($template, 0, 0, 210, 297, true);
                } else {
                    $pdf->addPage('L');
                    $pdf->useTemplate($template, 0, 0, 297, 210, true);                                                
                }
            }

            $pdf->Output(storage_path('app/public') . '/resized_' . $filename, 'F');
            return rename(storage_path('app/public') . '/resized_' . $filename, storage_path('app/public') . '/' . $filename);
        } catch (Exception $e) {
            $errorMessage = $e->getMessage();
            return false;
        }
    }
}
