<?php

namespace App\Http\Services;

final class SMSService 
{
    private $sender = 'DKB SIGN';
    private $token = 'VZTOCUBvwyGiuO9kGn0U4YIM1NzXTO';

    private function createCampaign(string $telephone, string $codeAuth, string $sender, string $recipient): array
    {
        $data = [
            'step' => null,
            'sender' => $this->sender,
            'name' => 'Code d\'authentification',
            'campaignType' => 'SIMPLE',
            'recipientSource' => 'CUSTOM',
            'groupId' => null,
            'filename' => null,
            'saveAsModel' => false,
            'destination' => 'NAT_INTER',
            'message' => "Bonjour Mme/Mr, @" . $sender . " vous a envoyé un document à signer à votre adresse mail \"$recipient\". Votre code d'accès au document est : $codeAuth",
            'emailText' => null,
            'recipients' => [['phone' => '225' . $telephone]],
            'sendAt' => [],
            'dlrUrl' => 'https://dkbsign.com',
            'responseUrl' => 'https://dkbsign.com',
        ];

        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://api.letexto.com/v1/campaigns',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($data),
            CURLOPT_HTTPHEADER => array(
                'Authorization: Bearer ' . $this->token,
                'Content-Type: application/json'
            )
        ));
          
        $response = curl_exec($curl);
        curl_close($curl);

        return json_decode($response, true);
    }

    private function startCampaign(string $id)
    {
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://api.letexto.com/v1/campaigns/' . $id . '/schedules',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_HTTPHEADER => array(
                'Authorization: Bearer ' . $this->token,
            ),
        ));

        $response = curl_exec($curl);
        curl_close($curl);
        
        return json_decode($response, true);
    }

    public function send(string $telephone, string $codeAuth, string $sender, string $recipient)
    {
        $campaign = $this->createCampaign($telephone, $codeAuth, $sender, $recipient);

        if (isset($campaign['error'])) {
            return [
                'status' => 'error',
                'message' => 'Bad request'
            ];
        }

        return $this->startCampaign($campaign['id']);
    }
}
