<?php

namespace App\Http\UseCases\Api\Certificat;

use App\Http\UseCases\Api\AbstractUseCase;
use App\Models\Certificat;
use Illuminate\Http\JsonResponse;

final class DeleteUseCase extends AbstractUseCase
{
    public function handle(Certificat $certificat): JsonResponse
    {
        return $certificat->delete()
            ? $this->success("Le certificat a été supprimé avec succès")
            : $this->error("Echec de la suppression du certificat", 400);
    }
}