<?php

namespace App\Http\UseCases\Api\Certificat;

use App\Http\UseCases\Api\AbstractUseCase;
use App\Models\Certificat;
use Illuminate\Http\JsonResponse;

final class UpdateUseCase extends AbstractUseCase
{
    public function handle(Certificat $certificat, array $data): JsonResponse
    {
        return $certificat->update($data)
            ? $this->success("Le certificat a été mis à jour avec succès")
            : $this->error("Echec de la mise à jour du certificat", 400);
    }
}
