<?php

namespace App\Http\UseCases\Api\Signataire;

use Illuminate\Http\JsonResponse;
use App\Http\Services\SignatureService;
use App\Http\UseCases\Api\AbstractUseCase;

final class GetItemUseCase extends AbstractUseCase
{
    public function __construct(
        private SignatureService $signatureService
    ) {}

    public function handle(string $document): JsonResponse
    {
        file_put_contents(
            storage_path('app/public') . '/' . $document,
            file_get_contents($this->signatureService->getSignedDocumentItem($document))
        );

        return $this->success(['filename' => url('/storage') . '/' . $document]);
    }
}
