<?php

namespace App\Http\UseCases\Api\Signataire;

use App\Http\UseCases\Api\AbstractUseCase;
use App\Models\Signataire;
use Illuminate\Http\JsonResponse;

final class GetSignataireCollectionUseCase extends AbstractUseCase
{
    public function handle(string $signataire): JsonResponse
    {
        $signataires = Signataire::query()
            ->where('telephone', $signataire)
            ->where('statut', Signataire::STATUT_EN_ATTENTE)
            ->orderBy('created_at', 'desc')
            ->get();

        return $this->success($signataires);
    }
}
