<?php

namespace App\Http\UseCases\Api\Signataire;

use App\Http\UseCases\Api\AbstractUseCase;
use App\Models\Signataire;
use App\Models\User;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\DB;

final class GetStatisticsUseCase extends AbstractUseCase
{
    public function handle(User $user, ?string $start = null, ?string $end = null): JsonResponse
    {
        $data = Signataire::query()
            ->where(function ($q) use ($user) {
                $q->where('user_id', $user->id)
                    ->orWhere('telephone', $user->telephone);
            })
            ->when(!is_null($start) && !is_null($end), function ($q) use ($start, $end) {
                return $q->where(DB::raw('date(created_at)'), '>=', $start)
                    ->where(DB::raw('date(created_at)'), '<=', $end);
            })
            ->selectRaw('count(id) as count, statut')
            ->selectRaw('sum(consulte) as consulte_count')
            ->groupBy('statut')
            ->get();
        
        $result = [
            'signe' => ['count' => 0, 'consulte' => 0],
            'refuse' => ['count' => 0, 'consulte' => 0],
            'en_attente' => ['count' => 0, 'consulte' => 0],
            'en_cours' => ['count' => 0, 'consulte' => 0]
        ];

        foreach ($data as $d) {
            $result[$d->statut] = ['count' => $d->count, 'consulte' => (int) $d->consulte_count];
        }

        return $this->success($result);
    }
}
