<?php

namespace App\Http\UseCases\Api\Signataire;

use App\Http\UseCases\Api\AbstractUseCase;
use App\Models\Signataire;
use Illuminate\Http\JsonResponse;

final class VerifyUseCase extends AbstractUseCase
{
    public function handle(string $token, $data): JsonResponse
    {
        $data['telephone'] = $token;

        return Signataire::query()->where($data)->exists() 
            ? $this->success("Code d'authentification incorrect")
            : $this->error("Code d'authentification incorrect", 400);
    }
}
