<?php

namespace App\Http\UseCases\Api\User;

use App\Http\Resources\UserCollection;
use App\Models\User;

final class GetCollectionUseCase
{
    public function handle(?int $page = null, ?int $limit = null, ?string $search = null): UserCollection
    {
        $query = User::query()
            ->where('role', User::ROLE_USER)
            ->when(!is_null($search), function ($q) use ($search) {
                return $q->where('nom', 'like', "%$search%")
                    ->orWhere('prenoms', 'like', "%$search%")
                    ->orWhere('email', 'like', "%$search%")
                    ->orWhere('telephone', 'like', "%$search%");
            })
            ->orderBy('created_at', 'desc');

        if (!is_null($limit)) {
            return new UserCollection($query->paginate($limit, ['*'], 'page', $page));
        }

        return new UserCollection($query->get());
    }
}
