<?php

namespace App\Imports;

use App\Models\Contact;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\Importable;
use Maatwebsite\Excel\Concerns\WithHeadingRow;

class ContactsImport implements ToModel, WithHeadingRow
{
    use Importable;

    public function __construct(
        public int $userId
    ) {}

    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    public function model(array $row)
    {
        if (
            !Contact::query()
                ->where('user_id', $this->userId)
                ->where(function ($query) use ($row) {
                    $query
                        ->where('telephone', $row['telephone'])
                        ->orWhere('email', $row['email']);
                })
                ->exists()
        ) {
            return new Contact([
                'user_id' => $this->userId,
                'nom' => $row['nom'],
                'telephone' => $row['telephone'],
                'email' => $row['email'],
            ]);
        }
    }
}
