<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class PendingSignatureOTPNotification extends Mailable implements ShouldQueue
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(
        public string $url,
        public string $sender,
        public string $recipient,
        public string $phone
    ) {}

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this
            ->subject('Document(s) en attente de signature')
            ->from('no-reply@dkbsign.com', 'DKBSign')
            ->markdown('mail.signature.pending-otp', [
                'url' => $this->url,
                'sender' => $this->sender,
                'recipient' => $this->recipient,
                'smsURL' => 'https://dkbsign.com/code_authentification?signatire=' . $this->phone
            ]);
    }
}
