<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Entreprise extends Model
{
    use HasFactory;

    protected $with = ['certificat'];

    protected $fillable = [
        'certificat_id',
        'raison_sociale',
        'telephone',
        'email',
        'otp_sms'
    ];

    public function users(): HasMany
    {
        return $this->hasMany(User::class);
    }

    public function certificat(): BelongsTo
    {
        return $this->belongsTo(Certificat::class);
    }
}
