<?php

use App\Models\User;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\Api\CertificatController;
use App\Http\Controllers\Api\ContactController;
use App\Http\Controllers\Api\EntrepriseController;
use App\Http\Controllers\Api\NotificationsController;
use App\Http\Controllers\Api\SignataireController;
use App\Http\Controllers\Api\UserController;

Route::post('/login', [AuthController::class, 'login']);

Route::prefix('/signatures')
    ->controller(SignataireController::class)
    ->group(function () {
        Route::post('/accepter', 'accept');
        Route::post('/refuser', 'reject');
        Route::post('/formater', 'format');
    });

Route::prefix('/signataires')
    ->controller(SignataireController::class)
    ->group(function () {
        Route::get('/{signataire}', 'show');
        Route::post('/{signataire}', 'verify');
        Route::get('/{signataire}/code-authentification', 'sms');
    });

Route::middleware('auth:sanctum')
    ->group(function () {
        Route::post('/logout', [AuthController::class, 'logout']);

        Route::middleware('role:' . User::ROLE_USER)
            ->group(function () {
                Route::apiResource('contacts', ContactController::class);
                Route::post('/contacts/importer', [ContactController::class, 'import']);

                Route::prefix('/signatures')
                    ->controller(SignataireController::class)
                    ->group(function () {
                        Route::get('/', 'index');
                        Route::get('/statistiques', 'statistics');
                        Route::post('/', 'store');
                        Route::patch('/consulter', 'view');
                    });

                Route::apiResource('notifications', NotificationsController::class)->except(['update', 'show', 'edit']);
            });

        Route::middleware('role:' . User::ROLE_ADMIN)
            ->group(function () {
                Route::apiResource('entreprises', EntrepriseController::class);
                Route::get('/entreprises/{entreprise}/utilisateurs', [EntrepriseController::class, 'users']);
                Route::apiResource('certificats', CertificatController::class);
                Route::apiResource('utilisateurs', UserController::class);
            });
    });
