<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Mail\ContactMail;
use App\Mail\ContactMarkdownMail;
use App\Mail\ContactMarkdownMailAdmin;
use App\Models\Contact;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;

class ContactController extends Controller
{
    public function index()
    {
        $data = Contact::orderBy('created_at', 'DESC')->get();

        return response()->json([
            'data' => $data,
            'status' => 'success',
            'response' => 'Liste des contacts affiché'
        ]);
    }

    public function sendContactMail(Request $request, Contact $contact)
    {
        $data = $request->query();

        $contact->nom = $request->query('nom');
        $contact->prenom = $request->query('prenom');
        $contact->email = $request->query('email');
        $contact->contact = $request->query('contact');
        $contact->etr_name = $request->query('etr_name');
        $contact->ctr_interet = $request->query('ctr_interet');
        $contact->atr_preciser = $request->query('atr_preciser');

        $contact->save();

        // Mail::to($data['email'])->send(new ContactMail($data));

        Mail::to($data['email'])->send(new ContactMarkdownMail($data));

        Mail::to('info@dkbsolutions.com')->send(new ContactMarkdownMailAdmin($data));

        return response()->json([
            'status' => 'success',
            'response' => 'Contact enregistré avec succès, veuillez verifier votre mail svp !'
        ]);

    }
}
